/*
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 * 5724-U18
 * (C) COPYRIGHT IBM CORP. 2013 All Rights Reserved.
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 *
 */

/**
 * MODIF SQLI
 * Ne jamais faire le focus sur les boutons "Nouvelle ligne"
 */
var tpae_focusElement = window.focusElement;

window.focusElement = function(element) {
	if (element && element.textContent && element.textContent.trim() == 'Nouvelle ligne') {

		return;
	}
  
	/**
	 * MODIF SQLI
	 * Mantis 3185 : Remplace les Labels des élement avec la classe 'labelToReplace' par la valeur de l'attribut correspondant. Uniquement dans l'application 'Capitalisation des Gammes (Lavera)'
	 * 		Conditions pour le remplacement d'un Label : 
	 * 			- Le label à remplacer doit avoir la classe 'labelToReplace', et etre de type span. Pour cela, sur l'XML du concepteur d'appli, il s'agit d'un élement du tableau tablecol avec l'attribut cssclass="labelToReplace"
	 *			- Le label sera remplacé par le label de l'élement qui possède la classe css nommée par le label actuel. Ex: Si le label d'origine est GAMMECOL1, il sera remplacé par le label de l'élement possèdant la classe css 'GAMMECOL1'
	 */
	if(document.title == 'Préparations (Lavéra)'){
		var labelsToReplace = document.querySelectorAll("th.labelToReplace span");
		
		for (var i = 0; i < labelsToReplace.length; i++) {
			var attributName = labelsToReplace[i].textContent;
			
			if (attributName) {
				var srcElement = document.getElementsByClassName(attributName.slice(0, -1).trim())[0];	// On enleve le '?' à la fin du label car il s'agit d'un yorn ainsi que les espaces si il y en a
				
				if (srcElement) {
					
					var typeElement = document.getElementsByClassName(attributName.slice(0, -2) + '-TYPE')[0];	// Récupère l'élement Type de visite à concatener à la fin
				
					if (typeElement && typeElement.value) {
						labelsToReplace[i].textContent = srcElement.value + '(' + typeElement.value + ')';
					} else {
						labelsToReplace[i].textContent = srcElement.value;
					}
				}
			}			
		}
	}

	tpae_focusElement(element);
}

