<%--
* Copyright IBM Corporation 2009-2017
*
* Licensed under the Eclipse Public License - v 1.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* https://www.eclipse.org/legal/epl-v10.html
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
* 
* @Author Doug Wood
--%>
<%@page import="psdi.webclient.components.*"%>
<%@ include file="../bim/bimheader.jsp" %>
<!DOCTYPE html>    
<html>
	<head>
		<link rel="stylesheet" href="<%=CSS_PATH%>/maximo.css">
		<style>
			.exviewer {
				background: gray;
				border-style: solid;
				height: 500px;
				width: 500px; 
			}
			.exviewer div {
				position: absolute;
				background: lightskyblue;
				border-style: solid;
				height: 100px;
				width: 100px;
				text-align: center;
				verticle-align: middle;
				line-height: 100px;
			}
			.box-asset1 {
				top: 100px;
				left: 100px;
			}
			.box-asset2 {
				top: 100px;
				left: 300px;
			}
			.box-asset3 {
				top: 300px;
				left: 100px;
			}
			.box-asset4 {
				top: 300px;
				left: 300px;
			}
			.exviewer div:hover {
				border-color: orange;
			}
		</style>
		<script type = "text/javascript" 
				src  = "<%=servletBase%>/javascript/bimviewer.js">
		</script>
	</head>  
	<body oncontextmenu="return false;" style="width:100%; height:100%;">

		<!-- use ctrlId as the id of the "viewer" or viewer container -->
		<div id="<%=ctrlId%>">
			<%@ include file="scripts.jsp" %>
			<%@ include file="../bim/script-common.jsp" %>

			<div id="<%=ctrlId%>_exviewer" class="exviewer">
				<div id="<%=id%>_exviewer_box1" class="box-asset1"></div>
				<div id="<%=id%>_exviewer_box2" class="box-asset2"></div>
				<div id="<%=id%>_exviewer_box3" class="box-asset3"></div>
				<div id="<%=id%>_exviewer_box4" class="box-asset4"></div>
			</div>
		</div>
		<script id=<%=id%>_container type="text/javascript" defer >
			// it's not necessary to call loadControl(), however this shows how you can initialize here
			loadControl( "<%=ctrlId%>", "<%=id%>_exviewer_box1", "<%=id%>_exviewer_box2", "<%=id%>_exviewer_box3", "<%=id%>_exviewer_box4" );

		</script>
	  
	</body>
</html>

<%@ include file="../bim/bimfooter.jsp" %>