<%--
* Copyright IBM Corporation 2009-2017
*
* Licensed under the Eclipse Public License - v 1.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* https://www.eclipse.org/legal/epl-v10.html
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
* 
--%>
<script id=<%=id%>_container type="text/javascript" >
"use strict";
var ctrlEXViewer = null;
var ctrlBoxes = new Array();
var curBox = 0;

function loadControl(
	exviewer,
	box1,
	box2,
	box3,
	box4
) {
	if(ctrlEXViewer != undefined && ctrlEXViewer != null && ctrlEXViewer.id == exviewer)
	{
		return;
	}
	// create references to the objects in the viewer
	// test2
	ctrlEXViewer = document.getElementById( exviewer );
	ctrlBoxes[ctrlBoxes.length] = document.getElementById( box1 );
	ctrlBoxes[ctrlBoxes.length] = document.getElementById( box2 );
	ctrlBoxes[ctrlBoxes.length] = document.getElementById( box3 );
	ctrlBoxes[ctrlBoxes.length] = document.getElementById( box4 );
	
	// this could be passing the viewer an object that it could use to reach ViewerWrapper.onSelect
	// or adding an event listener to it, or anything that would enable the viewer to trigger ViewerWrapper.onSelect
	for(var i=0;i<ctrlBoxes.length;i++)
	{
		ctrlBoxes[i].onclick = function() { 
			var eventElementId = event.target.id;
			ctrlBoxes[curBox].style.background = "lightskyblue"; // show current as deselected
			if(currentDataJSON.assetnum != undefined && ctrlBoxes[curBox].innerHTML == "") {
				ctrlBoxes[curBox].innerHTML = currentDataJSON.assetnum;
			}
			for(var j=0;j<ctrlBoxes.length;j++)
			{
				if(ctrlBoxes[j].id == eventElementId)
				{
					curBox = j;
					ctrlBoxes[curBox].style.background = "orange"; // indicate that this is selected
					viewer.onSelect(this.title); // the ViewerWrapper "viewer" is initialized in script-common.jsp initModelManager()
					return;
				}
			}
		};
	}
}

/**********************************************************************/
// This class contains all the functions needed to interact with the 
// native viewer 
/**********************************************************************/
function ViewerWrapper(
	ctrl	// The control handle
) {

    this.getInterfaceVersion = function()
    {

    };

	this.initialize = function(
		modelMgr,
		selectionMgr
	) {

	};
	
	this.loadFile = function(  
		file
	) {

	};
	
	this.selectValue = function( 
		value, 
		zoomToContext 
	) {
		if(ctrlBoxes[curBox].title == value)
		{
			return; // if we're on the same one, do nothing
		}
		if(ctrlBoxes[curBox].title != undefined && ctrlBoxes[curBox].title != "") // start at index 0 if not initialized yet
		{
			ctrlBoxes[curBox].style.background = "lightskyblue"; // show current as deselected
			curBox = curBox + 1; // set up to update the next in the list
		}
		if(curBox == ctrlBoxes.length) curBox = 0; // there are only four boxes in our example
		console.log(">>> box[" + curBox + "] title set to: " + value);
		ctrlBoxes[curBox].title = value; // set the tooltip
		ctrlBoxes[curBox].style.background = "orange"; // indicate that this is selected
		
	};

	this.selectValueList = function(
		valueList,		// Array of itds to select
		zoomToContext
	) {

	};

	this.setCurrentModel = function(
		currentModel
	) {

	};
	
	this.getSelection = function( 
		index 
	) {

	};
	
    this.getSelectionList = function() 
    {
		var ids = [];
		ids.push( ctrlBoxes[curBox].title );
		return ids;
    };
    
    this.getSelectionCount = function()
    {

    };
    
    this.getItemIndex = function(
    	selectedItem	// Any item in the list of selected items
 	) {
		if( !selectedItem ) return -1;
		
		for( var i = 0; i < ctrlBoxes.length; i++ )
		{
			if( ctrlBoxes[i].title == selectedItem )
			{
				return i + 1;
			}
		}
		return -1;
    };
    
    this.clearSelection = function()
    {

    };
    
    this.focusOnSelectedItem = function(
    	itemIndex	// The idex of the item in the selection list
	) {

    };
    
    this.enableMultiSelect = function (
   		enable
	) {

    };
	
	this.setAutoZoom = function(
		enable
	) {

	};
	
	this.reziseViewer = function(
		height,
		width
	) {
		
	};
    
    this.onSelectionChange = function(
		ctrl,
		selectionList,
		selection,
		count,
		index 
	) {

	};
	
	this.onSelect = function(
		selection
	) {
		console.log("viwermanager onSelect: " + event.target);
		selMgr.updateSelectionSet( event.target ); // the SelectionManager "selMgr" is initialized in script-common.jsp initModelManager()
		//alert("onSelect currentDataJSON: " + currentDataJSON);
		//alert("onSelect currentDataJSON.whoami: " + currentDataJSON.whoami);
		//alert("onSelect currentDataJSON.assetnum: " + currentDataJSON.assetnum);
	};
	
	this.displayError = function(
		message
	) {

	};
	
	this.onScreeModeChange = function(
		mode
	) {

	};
	
	this.displayProperties = function(
		mbo
	) {

	}

	this.onToolbarCreate = function(
		forgeViewer, parentToolBar
	) {

	};
	
	this.indexKeyPress = function()
	{

	};
}

/**********************************************************************/
// 
/**********************************************************************/
function MaximoToolBar(
	wrapper, forgeViewer
) {
	
	this.makeToolBar = function()
	{

	}
	
	this.makeModelSubToolbar = function(
		modelMgr,
		toolBar	
	) {

	}

	this.selectModel = function()
	{

	}
	
	this.makeRequestSubToolbar = function(
		toolBar
	) {

	}
	
	this.makeSystemSubToolbar = function(
		toolBar
	) {

	}
	
	this.makeWOSubToolbar = function(
		toolBar
	) {

	}
	
	this.makeResizeSubToolbar = function(
		toolBar
	) {

	}
	
	this.onScreenModeCahnge = function(
		mode
	) {

	}
	
	this.onMarkupModeChange = function(
		evt
	) {

	}
	
	this.show = function(
		isShown
	) {

	}
	
}
</script>