/*
 * Decompiled with CFR 0.152.
 */
package psdi.webclient.servlet;

import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Hashtable;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import psdi.server.MXServer;

public class BIMServlet
extends HttpServlet {
    private static final long serialVersionUID = 5182623260077384490L;
    private final Hashtable<String, AuthToken> _authTokens = new Hashtable();
    public static final String LMV_KEY = "bim.viewer.LMV.key";
    public static final String LMV_SECRET = "bim.viewer.LMV.secret";
    public static final String LMV_HOST = "bim.viewer.LMV.host";
    private static final String AUTH_FRAGMENT = "/authentication/v1/authenticate";
    private final String _protocol = "https";
    private final int _port = -1;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String methodName = this.isRESTCall(request);
        if (methodName != null) {
            this.doRESTGet(request, response, methodName);
            return;
        }
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String methodName = this.isRESTCall(request);
        if (methodName != null) {
            this.doRESTPost(request, response, methodName);
            return;
        }
        this.processRequest(request, response);
    }

    private String isRESTCall(HttpServletRequest request) {
        String context;
        String urlPath;
        String uri = request.getRequestURI();
        if (uri.startsWith(urlPath = (context = request.getContextPath()) + "/models/Sys/")) {
            return uri.substring(urlPath.length());
        }
        return null;
    }

    protected void doRESTGet(HttpServletRequest request, HttpServletResponse response, String methodName) throws ServletException, IOException {
        if (methodName.equals("AD/Auth")) {
            // empty if block
        }
    }

    protected void doRESTPost(HttpServletRequest request, HttpServletResponse response, String methodName) throws ServletException, IOException {
        if (methodName.equals("AD/Auth")) {
            this.restAutodeskViewerAuth(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restAutodeskViewerAuth(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        URI uri;
        response.setContentType("application/json; charset=utf-8");
        MXServer server = MXServer.getMXServer();
        String key = server.getProperty(LMV_KEY);
        AuthToken authToken = this._authTokens.get(key);
        if (authToken != null) {
            if (!authToken.isExpired()) {
                try (ServletOutputStream os = null;){
                    os = response.getOutputStream();
                    os.write(authToken.getRawData().getBytes(Charset.forName("UTF-8")));
                    return;
                }
            }
            this._authTokens.remove(key);
        }
        String secret = server.getProperty(LMV_SECRET);
        String host = server.getProperty(LMV_HOST);
        String body = "client_id=" + key + "&client_secret=" + secret + "&grant_type=client_credentials";
        try {
            uri = new URI("https", null, host, -1, AUTH_FRAGMENT, null, null);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        URL url = new URL(uri.toASCIIString());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (connection instanceof HttpsURLConnection) {
            // empty if block
        }
        try {
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(0);
            connection.setRequestProperty("Accept", "application/json; charset=utf-8");
            connection.setRequestProperty("Content-Length", "" + body.length());
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            connection.setDoOutput(true);
            OutputStream os = null;
            InputStream is = null;
            try {
                try {
                    os = connection.getOutputStream();
                    os.write(body.getBytes(Charset.forName("UTF-8")));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
                int status = connection.getResponseCode();
                if (status > 299) {
                    String errStr = this.stream2string(connection.getErrorStream());
                    response.sendError(status, errStr);
                    return;
                }
                is = connection.getInputStream();
                String dataStr = this.stream2string(is);
                AuthToken token = new AuthToken(dataStr);
                this._authTokens.put(key, token);
                response.setContentLength(dataStr.length());
                os = response.getOutputStream();
                os.write(dataStr.getBytes(Charset.forName("UTF-8")));
            }
            finally {
                if (os != null) {
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
            }
        }
        finally {
            connection.disconnect();
            connection = null;
            url = null;
        }
    }

    private String stream2string(InputStream is) throws IOException {
        String output;
        if (is == null) {
            return "";
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer buf = new StringBuffer();
        while ((output = br.readLine()) != null) {
            buf.append(output);
        }
        return buf.toString();
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FileInputStream istream;
        String context;
        String urlPath;
        Object objSession = request.getSession().getAttribute("MXSession");
        if (objSession == null) {
            response.sendError(401);
            return;
        }
        String uri = request.getRequestURI();
        if (!uri.startsWith(urlPath = (context = request.getContextPath()) + "/models/")) {
            response.sendError(400);
            return;
        }
        String rootDir = MXServer.getMXServer().getProperty("bim.model.dir");
        if (rootDir.length() == 0) {
            response.sendError(404);
            return;
        }
        String fileName = uri.substring(urlPath.length());
        String fullPath = rootDir + File.separatorChar + fileName;
        String rangeHdr = request.getHeader("Range");
        if (rangeHdr != null && rangeHdr.length() > 0) {
            this.processRangeRequest(request, response, fullPath);
            return;
        }
        File modelFile = new File(fullPath);
        if (!modelFile.exists()) {
            response.sendError(404);
            return;
        }
        try {
            istream = new FileInputStream(modelFile);
        }
        catch (FileNotFoundException e1) {
            response.sendError(404);
            return;
        }
        response.setStatus(200);
        response.setContentType("application/octet-stream");
        response.addHeader("Content-Length", "" + modelFile.length());
        ServletOutputStream out = response.getOutputStream();
        try {
            int bytesRead;
            byte[] b = new byte[8192];
            while ((bytesRead = istream.read(b)) >= 0) {
                out.write(b, 0, bytesRead);
            }
            out.flush();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        try {
            istream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void processRangeRequest(HttpServletRequest request, HttpServletResponse response, String fullPath) throws ServletException, IOException {
        FileInputStream fis;
        File modelFile;
        String rangeHdr = request.getHeader("Range");
        String[] split = rangeHdr.split("=");
        if (split.length != 2) {
            response.sendError(400);
            return;
        }
        String units = split[0].trim();
        String range = split[1].trim();
        if (!units.equalsIgnoreCase("bytes")) {
            response.sendError(416);
            return;
        }
        split = range.split(",");
        if (split.length != 1) {
            response.sendError(416);
            return;
        }
        int idx = range.indexOf(45);
        String start = null;
        long startLoc = -1L;
        String end = null;
        long endLoc = -1L;
        if (idx > 0) {
            start = range.substring(0, idx);
            startLoc = Long.parseLong(start);
        }
        if (idx != range.length()) {
            end = range.substring(idx + 1);
            endLoc = Long.parseLong(end);
        }
        if (!(modelFile = new File(fullPath)).exists()) {
            response.sendError(404);
            return;
        }
        try {
            fis = new FileInputStream(modelFile);
        }
        catch (FileNotFoundException e1) {
            response.sendError(404);
            return;
        }
        if (start == null && (startLoc = modelFile.length() - endLoc) < 0L) {
            startLoc = 0L;
        }
        if (end == null) {
            endLoc = modelFile.length();
        }
        if (endLoc > modelFile.length()) {
            endLoc = modelFile.length();
        }
        long size = endLoc - startLoc + 1L;
        response.setStatus(206);
        response.setContentType("application/octet-stream");
        if (startLoc == 0L) {
            response.addHeader("Content-Length", "" + modelFile.length());
        }
        ServletOutputStream out = response.getOutputStream();
        try {
            int bufSize = 8192;
            byte[] buffer = new byte[bufSize];
            fis.skip(startLoc);
            while (size > 0L) {
                int amountToRead = (long)bufSize > size ? (int)size : bufSize;
                int bytesRead = fis.read(buffer, 0, amountToRead);
                size -= (long)bytesRead;
                if (bytesRead < 0) break;
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
        }
        catch (Exception x) {
            response.sendError(500);
            System.out.println("Exception: " + x);
            x.printStackTrace();
        }
        try {
            fis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class AuthToken {
        private static final String KEY_TOKEN_TYPE = "token_type";
        private static final String KEY_EXPIRES_IN = "expires_in";
        private static final String KEY_ACCESS_TOKEN = "access_token";
        private final String _rawData;
        private String _token_type;
        private long _expires_in = -1L;
        private String _access_token;
        private final long _timeStamp = System.currentTimeMillis();

        protected AuthToken(String data) throws IOException {
            this._rawData = data;
            JSONArtifact jArtifact = JSON.parse((String)data);
            if (jArtifact instanceof JSONObject) {
                JSONObject jObj = (JSONObject)jArtifact;
                Object value = jObj.get((Object)KEY_TOKEN_TYPE);
                if (value instanceof String) {
                    this._token_type = (String)value;
                }
                if ((value = jObj.get((Object)KEY_EXPIRES_IN)) instanceof Long) {
                    this._expires_in = (Long)value;
                }
                if ((value = jObj.get((Object)KEY_ACCESS_TOKEN)) instanceof String) {
                    this._access_token = (String)value;
                }
            }
        }

        public String getRawData() {
            return this._rawData;
        }

        public boolean isExpired() {
            return this._timeStamp + this._expires_in - 5L < System.currentTimeMillis();
        }
    }
}

