/*
 * Decompiled with CFR 0.152.
 */
package psdi.webclient.controls;

import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import java.util.ListIterator;
import psdi.mbo.MboValueData;
import psdi.util.MXException;
import psdi.webclient.controls.Tree;
import psdi.webclient.controls.TreeNode;
import psdi.webclient.system.controller.ControlInstance;
import psdi.webclient.system.controller.WebClientEvent;
import psdi.webclient.system.session.WebClientSession;

public class BIMTree
extends Tree {
    private boolean _autoselect = true;
    private boolean _selectFirstNode = false;
    private boolean _amIinitialize = false;

    public void initialize() {
        if (this._amIinitialize) {
            return;
        }
        this._amIinitialize = true;
        this._selectFirstNode = this.getProperty("selectfirstnode").equals("true");
        this.setProperty("selectfirstnode", "false");
        super.initialize();
    }

    public void createNodes() {
        String id = this.getTreeDataBean().getuniqueidvalue();
        super.createNodes();
        try {
            if (this._autoselect) {
                id = this.getTreeDataBean().getuniqueidvalue();
                this.setSelectedNode(id, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSelectedNode(String uid) throws RemoteException, MXException {
        this.setSelectedNode(uid, true);
    }

    protected void setSelectedNode(String id, boolean sendEvent) throws RemoteException, MXException {
        WebClientSession wcs = this.getWebClientSession();
        ListIterator itr = this.getChildren().listIterator();
        long uid = -1L;
        TreeNode firstNode = null;
        while (itr.hasNext()) {
            ControlInstance ctrl = (ControlInstance)itr.next();
            if (!(ctrl instanceof TreeNode)) continue;
            TreeNode treeNode = (TreeNode)ctrl;
            if (firstNode == null) {
                firstNode = treeNode;
            }
            if (id == null || id.length() == 0) {
                if (this._selectFirstNode) {
                    treeNode.selectnode();
                }
                return;
            }
            if (uid < 0L) {
                try {
                    uid = NumberFormat.getIntegerInstance(wcs.getUserInfo().getLocale()).parse(id).longValue();
                }
                catch (ParseException e) {
                    if (this._selectFirstNode) {
                        treeNode.selectnode();
                    }
                    return;
                }
            }
            if (!this.selectNode(wcs, treeNode, uid, sendEvent)) continue;
            return;
        }
        if (firstNode != null && this._selectFirstNode) {
            firstNode.selectnode();
        }
    }

    protected boolean selectNode(WebClientSession wcs, TreeNode treeNode, long targetUID, boolean sendEvent) throws RemoteException, MXException {
        long nodeUID = this.getNodeId(wcs, treeNode);
        if (nodeUID < 0L) {
            return false;
        }
        if (targetUID == nodeUID) {
            if (sendEvent) {
                WebClientEvent wce = new WebClientEvent("selectnode", treeNode.getId(), null, wcs);
                this.getWebClientSession().queueEvent(wce);
            } else {
                this.setSelectedNode(treeNode);
            }
            return true;
        }
        return this.selectChildNode(wcs, treeNode, targetUID, sendEvent);
    }

    private long getNodeId(WebClientSession wcs, TreeNode treeNode) {
        Object[] obj = treeNode.getNodeData();
        if (obj != null && obj.length > 1 && obj instanceof MboValueData[]) {
            MboValueData[] mvd = (MboValueData[])obj;
            if (mvd[1].getData() == null) {
                return -1L;
            }
            try {
                return NumberFormat.getIntegerInstance(wcs.getUserInfo().getLocale()).parse(mvd[1].getData()).longValue();
            }
            catch (ParseException e) {
                return -1L;
            }
        }
        return -1L;
    }

    protected boolean selectChildNode(WebClientSession wcs, TreeNode treeNode2, long targetUID, boolean sendEvent) throws RemoteException, MXException {
        if (!treeNode2.hasChildNodes()) {
            return false;
        }
        List children = treeNode2.getChildren();
        for (TreeNode treeNode2 : children) {
            if (!this.selectNode(wcs, treeNode2, targetUID, sendEvent)) continue;
            return true;
        }
        return false;
    }

    public boolean isAutoselect() {
        return this._autoselect;
    }

    public void setAutoselect(boolean autoselect) {
        this._autoselect = autoselect;
    }
}

