/*
 * Decompiled with CFR 0.152.
 */
package psdi.webclient.components;

import com.ibm.json.java.JSONObject;
import java.beans.Beans;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import psdi.app.asset.AssetSetRemote;
import psdi.app.bim.viewer.BuildingModelSet;
import psdi.app.bim.viewer.BuildingModelSetRemote;
import psdi.app.location.Location;
import psdi.app.location.LocationRemote;
import psdi.app.location.LocationSetRemote;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.webclient.beans.asset.AssetAppBean;
import psdi.webclient.beans.bim.viewer.AssetLookup;
import psdi.webclient.beans.bim.viewer.AssetLookupMulti;
import psdi.webclient.beans.bim.viewer.BIMViewerEventBean;
import psdi.webclient.beans.bim.viewer.ModelAppBean;
import psdi.webclient.beans.bim.viewer.WOModelLocBean;
import psdi.webclient.beans.location.LocationAppBean;
import psdi.webclient.beans.workorder.WOAppBean;
import psdi.webclient.components.BIMModelSpec;
import psdi.webclient.controls.TabGroup;
import psdi.webclient.system.beans.AppBean;
import psdi.webclient.system.beans.DataBean;
import psdi.webclient.system.beans.ResultsBean;
import psdi.webclient.system.controller.AppInstance;
import psdi.webclient.system.controller.BaseInstance;
import psdi.webclient.system.controller.BoundComponentInstance;
import psdi.webclient.system.controller.ControlInstance;
import psdi.webclient.system.controller.PageInstance;
import psdi.webclient.system.controller.WebClientEvent;
import psdi.webclient.system.session.WebClientSession;

public class BIMViewer
extends BoundComponentInstance {
    public static final int VERSION_LESS_THAN_7116 = 0;
    public static final int VERSION_7116_OR_GREATER = 1;
    public static final int VERSION_75_OR_GREATER = 2;
    public static final String PROP_DATA_ATTRIB = "dataattribute";
    public static final String PROP_MODEL_ATTRIB = "modelattribute";
    public static final String PROP_CTRL_TARGET = "controltarget";
    public static final String FIELD_ASSETUID = "ASSETUID";
    public static final String FIELD_ASSETNUM = "ASSETNUM";
    public static final String FIELD_BUILDINGMODELID = "BUILDINGMODELID";
    public static final String FIELD_ORGID = "ORGID";
    public static final String FIELD_SITEID = "SITEID";
    public static final String FIELD_LOCATION = "LOCATION";
    public static final String FIELD_LOCATIONUID = "LOCATIONSID";
    public static final String FIELD_MODELID = "MODELID";
    public static final String FIELD_NETWORK = "NETWORK";
    public static final String FIELD_PARENT = "PARENT";
    public static final String FIELD_PRIMARYSYSTEM = "PRIMARYSYSTEM";
    public static final String FIELD_SYSTEMID = "SYSTEMID";
    public static final String FIELD_WO_NUM = "WONUM";
    public static final String TABLE_ASSET = "ASSET";
    public static final String TABLE_LOCATIONS = "LOCATIONS";
    public static final String TABLE_WORKORDER = "WORKORDER";
    public static final String TABLE_LOCACCESTOR = "LOCACCESTOR";
    public static final String TABLE_LOCHIERARCHY = "LOCHIERARCHY";
    public static final String TABLE_LOCSYSTEM = "LOCSYSTEM";
    public static final String HOST_PARAM_MARKER = "<HOSTNAME>";
    public static final String ATTRIB_RESIZE = "bim.resize";
    public static final String ATTRIB_RESIZE_DLG = "bim.resize.dlg";
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_ASSET = 1;
    public static final int TYPE_LOCATION = 2;
    public static final int TYPE_LOOKUP = 3;
    public static final int TYPE_WORKORDER = 4;
    public static final int TYPE_MODEL = 5;
    public static final int RECORD_UNKNOWN = 0;
    public static final int RECORD_ASSET = 1;
    public static final int RECORD_LOCATION = 2;
    public static final int RECORD_MODEL = 3;
    private static final String QUERY_LOC_MODELID = "=:1 and location in ( select location from locancestor where ancestor =:2  and systemid in (select systemid from locsystem where siteid =:3 and primarysystem = 1) ) ";
    private static final String QUERY_MODEL_FILE = "location in (select ancestor from locancestor where location =:1 and siteid =:2 and systemid =:3) and siteid =:2";
    private MXServer _server;
    private WebClientSession _wcs = null;
    private BuildingModelSetRemote _modelSet;
    private int _type = 0;
    private int _recordType = 0;
    private Vector<BIMModelSpec> _currentModelList = new Vector();
    private boolean _hasModelListChanged = true;
    private String _currentValue = "";
    private boolean _hasValueChanged = true;
    private boolean _forceUpdate = false;
    private boolean _isMultiSelectAllowed = false;
    private String _lookupValue = null;
    private boolean _controlVisible = false;
    private Set<String> _currentSelection;
    private Set<String> _multiSelection = null;
    private boolean _multeSelectZoomToContext = false;
    private boolean _isSelectionValid = true;
    private String _binding = null;
    private String _modelId = null;
    private String _modelLocation = null;
    private boolean selectionEnabled = true;
    private String _tabGroupName = null;
    private String _tabName = null;
    private String _statusUpdate = null;
    private String _width = "950px";
    private int _height = 468;
    private int _controlTop = 0;
    private int _controlLeft = 0;
    private int _topOffset = 0;
    private int _leftOffset = 0;
    private int _mxVersion = 0;
    private String _activeViewer = "navisworks";
    private DataBean eventBean = null;
    boolean jspInitialized = false;

    public void instantiatedatasrc() {
        super.instantiatedatasrc();
    }

    private void setupEventClass() {
        WebClientSession wcs = this.getWebClientSession();
        String eventClassName = this.getProperty("eventclass");
        if (eventClassName != null && !eventClassName.equals("")) {
            ControlInstance creator = wcs.getCurrentEventHandler();
            try {
                ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                this.eventBean = (DataBean)Beans.instantiate(classLoader, eventClassName);
                this.eventBean.setId(this.getId());
                this.eventBean.setCreator(creator);
                this.eventBean.setupBean(wcs);
            }
            catch (ClassNotFoundException ex) {
                System.err.println("Could not instantiate eventclass for control " + creator.getId() + " because the implentation class " + eventClassName + " was not found");
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    public int handleEvent(String methodName, WebClientEvent event) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.eventBean != null) {
            Integer evtResult = 2;
            try {
                Class<?> ec = this.eventBean.getClass();
                Method m = ec.getMethod(methodName, null);
                evtResult = (int)((Integer)m.invoke((Object)this.eventBean, null));
                event.setProcessed();
                event.getWebClientSession().serviceability.requests.addHandledBy(event, (Object)this);
                if (evtResult instanceof Integer) {
                    if (evtResult == 2) {
                        return super.handleEvent(methodName, event);
                    }
                    return evtResult;
                }
                return 2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.handleEvent(methodName, event);
    }

    public void initialize() {
        super.initialize();
        this.setupEventClass();
        this._wcs = this.getWebClientSession();
        this._controlVisible = false;
        this._currentSelection = new HashSet<String>();
        try {
            this._server = MXServer.getMXServer();
            String version = this._server.getMaxupgValue();
            if (version.compareTo("V7116") >= 0) {
                this._mxVersion = 1;
            }
            if (version.compareTo("V75") >= 0) {
                this._mxVersion = 2;
            }
            if (version.compareTo("V76") >= 0) {
                this._mxVersion = 2;
            }
            try {
                this._activeViewer = this._server.getProperty("bim.viewer.active");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DataBean db = this.getDataBean();
            MboSetRemote mboSet = null;
            try {
                mboSet = db.getMboSet();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            UserInfo userInfo = mboSet.getUserInfo();
            if (mboSet instanceof AssetSetRemote) {
                this._recordType = 1;
            } else if (mboSet instanceof LocationSetRemote) {
                this._recordType = 2;
            } else if (mboSet instanceof BuildingModelSet) {
                this._recordType = 3;
            }
            this._modelSet = (BuildingModelSetRemote)this._server.getMboSet("BUILDINGMODEL", userInfo);
            this._modelSet.setWhere("siteid is null");
            this._modelSet.reset();
            if (!this.setupControlType(this.dataBean)) {
                DataBean bean = this.dataBean.getParent();
                this.setupControlType(bean);
            }
        }
        catch (Exception version) {
            // empty catch block
        }
        String binding = this.getProperty(PROP_DATA_ATTRIB);
        if (binding != null && binding.length() > 0) {
            this._binding = binding;
        }
        this._modelId = this.getProperty(PROP_MODEL_ATTRIB);
        if (this._modelId == null || this._modelId.length() == 0) {
            this._modelId = binding;
        }
        if (this._modelId == null || this._modelId.length() == 0) {
            this._modelId = "modelid";
        }
        this._tabGroupName = this.getProperty("tabgroup");
        if (this._tabGroupName == null || this._tabGroupName.length() == 0) {
            this._tabGroupName = "maintabs";
        }
        this._tabName = this.getProperty("tab");
        if (this._tabName == null || this._tabName.length() == 0) {
            this._tabName = "view";
        }
        this.setProperty("attributename", this._binding);
        String tmp = this.getProperty("topoffset");
        if (tmp != null && tmp.length() > 0) {
            this._topOffset = Integer.parseInt(tmp);
        }
        if ((tmp = this.getProperty("leftoffset")) != null && tmp.length() > 0) {
            this._leftOffset = Integer.parseInt(tmp);
        }
        this._height = (tmp = this.getProperty("height")) == null || tmp.equals("") ? 1 : Integer.parseInt(tmp);
        this._width = this.getProperty("width");
        this._width = this._width == null || this._width.equals("") ? "1" : this._width;
        tmp = this.getProperty("controltop");
        this._controlTop = tmp == null || tmp.equals("") ? 0 : Integer.parseInt(tmp);
        tmp = this.getProperty("controlleft");
        this._controlLeft = tmp == null || tmp.equals("") ? 0 : Integer.parseInt(tmp);
        tmp = this.getProperty("selection_enabled");
        if (tmp != null && tmp.length() > 0 && tmp.equalsIgnoreCase("FALSE")) {
            this.selectionEnabled = false;
        }
        if (this._type == 4) {
            AppInstance app = this.getWebClientSession().getCurrentApp();
            try {
                if (app.isSigOptionCheck("BIMVIEWER")) {
                    this._wcs.queueEvent(new WebClientEvent("bimviewer", this.getId(), (Object)this._binding, this._wcs));
                }
            }
            catch (MXException mXException) {}
        } else if (this._type == 3) {
            this._wcs.queueEvent(new WebClientEvent("bimviewer", this.getId(), (Object)this._binding, this._wcs));
        }
    }

    private boolean setupControlType(DataBean bean) {
        if (bean instanceof AssetAppBean) {
            this._type = 1;
            return true;
        }
        if (bean instanceof LocationAppBean) {
            this._type = 2;
            this._isMultiSelectAllowed = true;
            return true;
        }
        if (bean instanceof AssetLookup) {
            this._type = 3;
            return true;
        }
        if (bean instanceof AssetLookupMulti) {
            this._type = 3;
            this._isMultiSelectAllowed = true;
            return true;
        }
        if (bean instanceof WOAppBean || this.dataBean instanceof WOModelLocBean) {
            this._type = 4;
            this._isMultiSelectAllowed = true;
            return true;
        }
        if (bean instanceof ModelAppBean) {
            this._type = 5;
            this._isMultiSelectAllowed = false;
            return true;
        }
        return false;
    }

    public int render() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.checkVisibility();
        return super.render();
    }

    public int checkVisibility() {
        PageInstance currentPage = this.getPage();
        TabGroup maintab = (TabGroup)currentPage.getControlInstance(this._tabGroupName);
        boolean shouldAppVis = true;
        if (maintab != null) {
            shouldAppVis = maintab.getCurrentTab().getId().equalsIgnoreCase(this._tabName);
        }
        if (shouldAppVis != this.isControlVisible()) {
            this.setControlVisible(shouldAppVis);
            this.setChangedFlag();
        }
        return 1;
    }

    public int eventSelect() throws RemoteException, MXException {
        if (!this.selectionEnabled) {
            return 1;
        }
        WebClientEvent event = this._wcs.getCurrentEvent();
        Object o = event.getValue();
        if (o == null || !(o instanceof String)) {
            return 1;
        }
        String[] result = ((String)o).split(";");
        this._currentSelection = new HashSet<String>();
        if (result.length < 2) {
            return 1;
        }
        for (int i = 2; i < result.length; ++i) {
            this._currentSelection.add(result[i]);
        }
        this._modelLocation = result[0];
        this.setCurrentSelection(result[1]);
        return 1;
    }

    public void eventRezise() {
        WebClientEvent event = this._wcs.getCurrentEvent();
        Object o = event.getValue();
        HttpServletRequest thisRequest = this._wcs.getRequest();
        HttpSession session = thisRequest.getSession();
        session.setAttribute(ATTRIB_RESIZE, o);
    }

    public void eventReziseDlg() {
        WebClientEvent event = this._wcs.getCurrentEvent();
        Object o = event.getValue();
        HttpServletRequest thisRequest = this._wcs.getRequest();
        HttpSession session = thisRequest.getSession();
        session.setAttribute(ATTRIB_RESIZE_DLG, o);
    }

    protected void updateCurrentSelection(String value) {
        this._currentSelection = new HashSet<String>();
        if (value != null & !value.equals("")) {
            this._currentSelection.add(this.dataBean.getString(FIELD_MODELID));
        }
    }

    private boolean setCurrentSelection(String modelId) throws RemoteException, MXException {
        long uid = this.lookupUid(modelId);
        if (uid == -1L) {
            this.setNotFoundStatus();
            this._isSelectionValid = false;
            return false;
        }
        if (this._currentValue != null && this._currentValue.equalsIgnoreCase(modelId)) {
            return true;
        }
        this._currentValue = modelId;
        if (this.dataBean instanceof AppBean) {
            AppInstance app = this._wcs.getCurrentApp();
            AppBean appBean = (AppBean)this.dataBean;
            if (appBean.saveYesNoInteractionCheck()) {
                this.changeAppBeanRecordSet(app, appBean, uid);
                this._isSelectionValid = true;
            }
        } else {
            this.changeBeanRecordSet(this.dataBean, uid);
            this.dataBean.getMboForUniqueId(uid);
            this.dataBean.fireDataChangedEvent();
            this.dataBean.fireStructureChangedEvent();
            this._isSelectionValid = true;
        }
        if (this.dataBean instanceof AssetLookup) {
            this._lookupValue = modelId;
        }
        return true;
    }

    private void changeAppBeanRecordSet(AppInstance app, AppBean appBean, long uid) throws RemoteException, MXException {
        MboSetRemote resultsList;
        ResultsBean resultsBean = app.getResultsBean();
        int recordToSelect = this.findInMboSet(uid, resultsBean.getMboSet());
        if (recordToSelect == -1) {
            String userWhere = resultsBean.getCompleteWhere();
            userWhere = userWhere.isEmpty() ? userWhere : userWhere + " or ";
            userWhere = userWhere + "( " + appBean.getUniqueIdName() + " = " + uid + " )";
            appBean.initializeApp();
            resultsBean.resetQbe();
            resultsBean.setUserWhere(userWhere);
            resultsBean.reset();
        }
        if ((recordToSelect = this.findInMboSet(uid, resultsList = resultsBean.getMboSet())) != -1) {
            resultsBean.highlightrow(recordToSelect);
        }
    }

    private int findInMboSet(long uid, MboSetRemote mboSet) throws RemoteException, MXException {
        int recordToSelect = 0;
        MboRemote mbo = mboSet.getMbo(recordToSelect);
        while (mbo != null && mbo.getUniqueIDValue() != uid) {
            mbo = mboSet.getMbo(++recordToSelect);
        }
        recordToSelect = mbo == null ? -1 : recordToSelect;
        return recordToSelect;
    }

    public Set<String> jspGetMultiSelection() {
        Set<String> selection = this._multiSelection;
        this._multiSelection = null;
        return selection;
    }

    public String jspGetCurrentDataMM() throws RemoteException, MXException {
        StringBuffer script = new StringBuffer();
        if (this.eventBean != null) {
            String curData = ((BIMViewerEventBean)this.eventBean).getCurrentData(this.getProperty("attributespassed"));
            script.append("maximoToViewerMessage( ");
            script.append("{\"funcCall\": \"populateCurrentData\", \"passVar\": " + curData + "} ");
            script.append("); ");
        }
        return script.toString();
    }

    public String jspGetCurrentDataFrame() throws RemoteException, MXException {
        StringBuffer script = new StringBuffer();
        if (this.eventBean != null) {
            String curData = ((BIMViewerEventBean)this.eventBean).getCurrentData(this.getProperty("attributespassed"));
            script.append("");
            script.append("if( frame.populateCurrentData != undefined ) { ");
            script.append("frame.populateCurrentData( ");
            script.append(curData);
            script.append(" ); ");
            script.append(" } ");
        }
        return script.toString();
    }

    public String jspScript(String id) throws RemoteException, MXException {
        StringBuffer script = new StringBuffer();
        String containerTable = id + "container";
        String containerDiv = id + "_frameLoc";
        String controlTarget = this.getProperty(PROP_CTRL_TARGET);
        boolean designmode = this._wcs.getDesignmode();
        boolean needsRendered = this.needsRender();
        ControlInstance bimTarget = null;
        if (controlTarget != null && !controlTarget.equalsIgnoreCase("")) {
            bimTarget = this.getWebClientSession().getCurrentApp().getCurrentPage().getControlInstance(controlTarget);
        }
        BaseInstance bimParent = this.getParentInstance();
        if (!this.isControlVisible() && !this.jspInitialized) {
            return "";
        }
        String doc = "";
        if (!needsRendered && this.getMxVersion() < 2) {
            doc = "MAINDOC.";
        }
        script.append("");
        script.append("debugger;");
        script.append("try {");
        script.append("var containerTbl = " + doc + "document.getElementById( \"");
        script.append(containerTable);
        script.append("\" ); ");
        script.append("if( containerTbl != undefined ) { ");
        script.append("containerTbl.style.top = \"" + this.jspGetViewerTop() + "px\";");
        script.append("containerTbl.style.left = \"" + this._leftOffset + "px\";");
        script.append("}");
        script.append("var containerDiv = " + doc + "document.getElementById( \"");
        script.append(containerDiv);
        script.append("\" ); ");
        if (this.isControlVisible() && controlTarget != null && !controlTarget.equalsIgnoreCase("") && (bimTarget = this.getWebClientSession().getCurrentApp().getCurrentPage().getControlInstance(controlTarget)) != null) {
            script.append("var targetDiv = " + doc + "document.getElementById( \"");
            script.append(bimTarget.getRenderId() + "_bimtarget_targ");
            script.append("\" ); ");
            script.append("if(containerDiv != null && targetDiv != null) { ");
            script.append("if(containerDiv.parentElement != targetDiv) { ");
            script.append("targetDiv.viewerContainerParent = containerDiv.parentElement.id; ");
            script.append("targetDiv.viewerContainer = containerDiv.id; ");
            script.append("containerDiv.style.visibility = \"visible\"; ");
            script.append("containerDiv.style.display = \"block\"; ");
            script.append("moveToTarg(\"" + containerDiv + "\", \"" + bimTarget.getRenderId() + "_bimtarget_targ" + "\");");
            if (!this.jspInitialized) {
                script.append("var viewerframe = \"" + this.getWebClientSession().getMaximoRequestContextURL() + "/webclient/components/bim" + this.getViewerType() + "/viewerframe.jsp?rid=" + id + "&id=" + this.getId() + "&uisessionid=" + this.getWebClientSession().getUISessionID() + "\"; ");
                script.append("var iframe = document.createElement(\"iframe\"); ");
                script.append("iframe.frameBorder = 0; ");
                script.append("iframe.id = \"" + id + "_frame\"; ");
                script.append("iframe.setAttribute(\"src\", viewerframe); ");
                script.append("containerDiv.appendChild(iframe); ");
                this.jspInitialized = true;
            }
            script.append("var theFrame = " + doc + "document.getElementById( \"");
            script.append(id + "_frame");
            script.append("\" ); ");
            script.append("if(theFrame != null && theFrame != undefined) { ");
            script.append("targetDiv.style.border = \"0px\"; ");
            script.append("containerDiv.style.height = targetDiv.style.height; ");
            script.append("containerDiv.style.width = targetDiv.style.width; ");
            script.append("theFrame.style.height = containerDiv.style.height; ");
            script.append("theFrame.style.width = containerDiv.style.width; ");
            script.append("maximoToViewerMessage( ");
            script.append("{\"funcCall\": \"resizeCtrl\", \"passVar\": {\"height\": theFrame.style.height, \"width\": theFrame.style.width} } ");
            script.append("); ");
            script.append("} ");
            script.append("} ");
            script.append(" } ");
        }
        String value = null;
        boolean showModel = false;
        if (this.isControlVisible()) {
            showModel = this.itemHasModel();
            value = this.getValue();
        }
        if (this.isModelListChanged() || needsRendered) {
            script.append("maximoToViewerMessage( ");
            script.append("{\"funcCall\": \"initModelManager\", \"passVar\": null} ");
            script.append("); ");
            script.append(this.jspGetCurrentDataMM());
            script.append("maximoToViewerMessage( ");
            script.append("{\"funcCall\": \"resetModelList\", \"passVar\": null} ");
            script.append("); ");
            script.append(this.jspGetScriptModelList());
            script.append("maximoToViewerMessage( ");
            script.append("{\"funcCall\": \"populateModelList\", \"passVar\": \"" + value + "\"} ");
            script.append("); ");
            this.setModelListChanged(false);
            this.setValueChanged(false);
        } else if ((this.isValueChanged() || needsRendered) && this.getAppType() != 3) {
            script.append(this.jspGetCurrentDataMM());
            script.append("maximoToViewerMessage( ");
            script.append("{\"funcCall\": \"select\", \"passVar\": \"" + value + "\"} ");
            script.append("); ");
            this.setValueChanged(false);
        }
        script.append("} catch( e ) { console.log( e ); }");
        return script.toString();
    }

    public String scriptResize() {
        int opt;
        StringBuffer resize = new StringBuffer();
        resize.append("");
        if (!this.isControlVisible()) {
            resize.append("if( isLoaded ) { frame.resize( \"-1\" ); }");
            return resize.toString();
        }
        if (this.getAppType() == 3) {
            resize.append("if( isLoaded ) { frame.resizeDlg( \"");
            opt = this.jspGetRezieDlgOption();
        } else {
            resize.append("if( isLoaded ) { frame.resize( \"");
            opt = this.jspGetRezieOption();
        }
        resize.append(opt);
        resize.append("\" ); } ");
        this._width = this.getWidthFromResize(opt);
        this._height = this.getHeightFromResize(opt);
        return resize.toString();
    }

    private String getWidthFromResize(int opt) {
        String[] widths = new String[]{"1200", "1024", "1280", "1920", "1600", "1920", "1200"};
        if (opt > 0 && opt - 1 < widths.length) {
            return widths[opt - 1];
        }
        return this._width;
    }

    private int getHeightFromResize(int opt) {
        int[] heights = new int[]{720, 768, 1024, 1080, 1200, 1200, 800};
        if (opt > 0 && opt - 1 < heights.length) {
            return heights[opt - 1];
        }
        return this._height;
    }

    public String jspGetScriptModelList() {
        StringBuffer script = new StringBuffer();
        for (int i = 0; i < this._currentModelList.size(); ++i) {
            BIMModelSpec modelSpec = this._currentModelList.get(i);
            JSONObject jsonData = new JSONObject();
            jsonData.put((Object)"modelId", (Object)modelSpec.getModelId());
            jsonData.put((Object)"location", (Object)modelSpec.getLocation());
            jsonData.put((Object)"binding", (Object)modelSpec.getBinding());
            if (modelSpec.getTitle() != null && modelSpec.getTitle().length() > 0) {
                jsonData.put((Object)"title", (Object)modelSpec.getTitle());
            } else if (modelSpec.getDescription() != null && modelSpec.getDescription().length() > 0) {
                jsonData.put((Object)"title", (Object)modelSpec.getDescription());
            } else {
                jsonData.put((Object)"title", (Object)modelSpec.getLocationName());
            }
            jsonData.put((Object)"url", (Object)modelSpec.getModelURL());
            jsonData.put((Object)"attribClass", (Object)modelSpec.getAttribClass());
            jsonData.put((Object)"attribName", (Object)modelSpec.getAttribName());
            jsonData.put((Object)"paramClass", (Object)modelSpec.getParamClass());
            jsonData.put((Object)"paramName", (Object)modelSpec.getParamName());
            if (this._type == 1) {
                jsonData.put((Object)"defaultView", (Object)modelSpec.getAssetView());
            } else if (this._type == 2) {
                jsonData.put((Object)"defaultView", (Object)modelSpec.getLocationView());
            } else if (this._type == 3) {
                jsonData.put((Object)"defaultView", (Object)modelSpec.getLookupView());
            } else if (this._type == 4) {
                jsonData.put((Object)"defaultView", (Object)modelSpec.getWorkOrderView());
            }
            jsonData.put((Object)"selectionMode", (Object)modelSpec.getSelectionMode());
            jsonData.put((Object)"siteId", (Object)modelSpec.getSiteId());
            String mboKey = this.getMboKey();
            if (mboKey != null && mboKey.length() > 0) {
                jsonData.put((Object)"mboKey", (Object)mboKey);
            }
            script.append("maximoToViewerMessage( ");
            script.append("{\"funcCall\": \"addModel\", \"passVar\": " + jsonData.toString() + "} ");
            script.append("); ");
        }
        this._hasModelListChanged = false;
        String tmp = script.toString();
        return tmp;
    }

    public String scriptFooter() {
        StringBuffer footer = new StringBuffer();
        footer.append("");
        return footer.toString();
    }

    public int jspGetRezieOption() {
        HttpServletRequest thisRequest = this._wcs.getRequest();
        HttpSession session = thisRequest.getSession();
        Object o = session.getAttribute(ATTRIB_RESIZE);
        if (o == null || !(o instanceof String)) {
            return 0;
        }
        String option = (String)o;
        if (option.length() == 0) {
            return 0;
        }
        return Integer.parseInt(option);
    }

    public int jspGetRezieDlgOption() {
        HttpServletRequest thisRequest = this._wcs.getRequest();
        HttpSession session = thisRequest.getSession();
        Object o = session.getAttribute(ATTRIB_RESIZE_DLG);
        if (o == null || !(o instanceof String)) {
            return 0;
        }
        String option = (String)o;
        if (option.length() == 0) {
            return 0;
        }
        return Integer.parseInt(option);
    }

    public String jspGetStatusUpdate() {
        if (this._statusUpdate == null) {
            return "";
        }
        String status = this._statusUpdate;
        this._statusUpdate = null;
        return status;
    }

    public int jspGetViewerTop() {
        if (this.isControlVisible()) {
            return this._topOffset;
        }
        return -5000;
    }

    public boolean jspHasStatusUpdate() {
        return this._statusUpdate != null;
    }

    public int getAppType() {
        return this._type;
    }

    public String getBackgroundColor() {
        String color = this.getProperty("background_color");
        if (color != null && color.length() > 0) {
            return color;
        }
        String skin = this._wcs.getSkin();
        if (skin.contains("tivoli09") || skin.contains("tivoli13")) {
            return "#FFFFFF";
        }
        return "#000000";
    }

    public String getBoarderColor() {
        String color = this.getProperty("boarder_color");
        if (color != null && color.length() > 0) {
            return color;
        }
        String skin = this._wcs.getSkin();
        if (skin.contains("tivoli09") || skin.contains("tivoli13")) {
            return "#E0E0E0";
        }
        return "#808080";
    }

    public String getForegroundColor() {
        String color = this.getProperty("foreground_color");
        if (color != null && color.length() > 0) {
            return color;
        }
        String skin = this._wcs.getSkin();
        if (skin.contains("tivoli09") || skin.contains("tivoli13")) {
            return "#000000";
        }
        return "#FFFFFF";
    }

    public String getHighlightColor() {
        String color = this.getProperty("highlight_color");
        if (color != null && color.length() > 0) {
            return color;
        }
        String skin = this._wcs.getSkin();
        if (skin.contains("tivoli09") || skin.contains("tivoli13")) {
            return "#0404B0";
        }
        return "#40B040";
    }

    public String getBinding() {
        return this._binding;
    }

    public Set<String> getCurrentSelection() {
        return this._currentSelection;
    }

    public int getHeight() {
        return this._height;
    }

    public int getControlTop() {
        return this._controlTop;
    }

    public int getControlLeft() {
        return this._controlLeft;
    }

    public String getMboKey() {
        switch (this._type) {
            case 1: {
                return this.dataBean.getString(FIELD_ASSETNUM);
            }
            case 2: {
                return this.dataBean.getString(FIELD_LOCATION);
            }
            case 4: {
                AppInstance app = this.getWebClientSession().getCurrentApp();
                DataBean db = app.getAppBean();
                return db.getString(FIELD_WO_NUM);
            }
            case 5: {
                return this.dataBean.getString(FIELD_BUILDINGMODELID);
            }
            case 3: {
                return "";
            }
        }
        return "";
    }

    public int getLeftOffset() {
        return this._leftOffset;
    }

    public String getLookupValue() {
        return this._lookupValue;
    }

    public int getMxVersion() {
        return this._mxVersion;
    }

    public int getRecordType() {
        return this._recordType;
    }

    public String getSiteId() {
        return this.dataBean.getString(FIELD_SITEID);
    }

    public String getValue() {
        String value = this.getString();
        if (!this._binding.equalsIgnoreCase(this._modelId)) {
            value = this.dataBean.getString(this._modelId);
        }
        if (value == null) {
            value = "";
        }
        if (!value.equalsIgnoreCase(this._currentValue)) {
            this._hasValueChanged = true;
        }
        this._currentValue = value;
        return value;
    }

    public String getViewerType() {
        try {
            MXServer server = MXServer.getMXServer();
            String activeViewer = server.getProperty("bim.viewer.active");
            if (activeViewer != null && activeViewer.length() > 0) {
                return activeViewer;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "navisworks";
    }

    public String getWidth() {
        return this._width;
    }

    public boolean isForceUpdate() {
        return this._forceUpdate;
    }

    public boolean isHasMultiSelect() {
        return this._multiSelection != null;
    }

    private boolean itemHasModel() throws RemoteException, MXException {
        BIMModelSpec modelSpec;
        Vector<BIMModelSpec> modelList;
        String leafLocation = null;
        if (this.getRecordType() == 3) {
            modelList = new Vector<BIMModelSpec>();
            modelSpec = new BIMModelSpec(this.dataBean);
            if (modelSpec.getModelURL() != null && modelSpec.getModelURL().length() > 0) {
                modelList.add(modelSpec);
            }
        } else {
            this.getValue();
            this._forceUpdate = false;
            Location location = this.lookupLeafLocation();
            modelList = new Vector();
            String field = this._binding;
            if (this._recordType == 1) {
                field = this._modelId;
            }
            if (location != null) {
                leafLocation = location.getString(FIELD_LOCATION);
                MboSetRemote modelSet = this.lookupModelFileForLocation((LocationRemote)location);
                int count = 0;
                try {
                    count = modelSet.count();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int i = 0; modelSet != null && i < count; ++i) {
                    BIMModelSpec modelSpec2;
                    MboRemote model = modelSet.getMbo(i);
                    location = this.lookupLocation(model.getString(FIELD_LOCATION));
                    if (model == null) continue;
                    String locationName = location.getString(FIELD_LOCATION);
                    String locationId = location.getString(FIELD_LOCATION);
                    String binding = null;
                    if (location.getThisMboSet().getMboSetInfo().getAttribute(field) != null) {
                        binding = location.getString(field);
                    }
                    if ((modelSpec2 = new BIMModelSpec(locationName, locationId, binding, model)).getModelURL() == null || modelSpec2.getModelURL().length() <= 0) continue;
                    modelList.add(modelSpec2);
                }
            }
        }
        if (modelList.size() > 0) {
            modelSpec = (BIMModelSpec)modelList.get(0);
        } else {
            modelList.add(new BIMModelSpec());
            modelSpec = (BIMModelSpec)modelList.get(0);
            this._modelLocation = null;
            this._currentSelection = new HashSet<String>();
            this._currentSelection.add(this.dataBean.getString(FIELD_MODELID));
            this._currentModelList = modelList;
            leafLocation = null;
        }
        if (!this.compareModelLists(this._currentModelList, modelList)) {
            this._hasModelListChanged = true;
            this._modelLocation = null;
            this._currentSelection = new HashSet<String>();
            this._currentSelection.add(this.dataBean.getString(FIELD_MODELID));
            if (!modelList.isEmpty() && leafLocation == null) {
                modelSpec = modelList.elementAt(0);
                this._wcs.queueEvent(new WebClientEvent("bimModelListChanged", this.getId(), (Object)modelSpec.getLocation(), this._wcs));
            }
        }
        if (leafLocation != null) {
            this._wcs.queueEvent(new WebClientEvent("bimModelListChanged", this.getId(), (Object)leafLocation, this._wcs));
        }
        this._currentModelList = modelList;
        if (modelList.size() > 0) {
            // empty if block
        }
        return modelList.size() > 0;
    }

    public boolean isModelListChanged() {
        return this._hasModelListChanged;
    }

    public boolean isMultiSelectAllowed() {
        return this._isMultiSelectAllowed;
    }

    public boolean isSelectionValid() {
        return this._isSelectionValid;
    }

    public void forceUpdate() {
        this._forceUpdate = true;
    }

    public void setModelListChanged(boolean state) {
        this._hasModelListChanged = state;
    }

    private void setNotFoundStatus() {
        if (this._recordType == 1) {
            this._statusUpdate = this.getProperty("msg_not_asset");
        } else if (this._recordType == 2) {
            this._statusUpdate = this.getProperty("msg_not_location");
        } else {
            return;
        }
        this.setChangedFlag();
    }

    public boolean isValueChanged() {
        return this._hasValueChanged;
    }

    public void setValueChanged(boolean state) {
        this._hasValueChanged = state;
    }

    public boolean isControlVisible() {
        return this._controlVisible;
    }

    public void setControlVisible(boolean vis) {
        this._controlVisible = vis;
    }

    public void setMultiSelect(String modelLocation, Set<String> selection) throws RemoteException, MXException {
        this.setChangedFlag();
        if (selection.size() > 0) {
            String sel;
            Iterator<String> itr = selection.iterator();
            this._modelLocation = modelLocation;
            while (itr.hasNext() && !this.setCurrentSelection(sel = itr.next())) {
            }
        }
        this._currentSelection = selection;
        this._multiSelection = selection;
        this._multeSelectZoomToContext = true;
    }

    protected Location lookupLeafLocation() throws RemoteException, MXException {
        MboRemote mbo = null;
        if (this.getRecordType() == 1) {
            String locName = this.dataBean.getString(FIELD_LOCATION);
            if (locName == null || locName.length() == 0) {
                return null;
            }
            mbo = this.lookupLocation(locName);
            if (mbo != null && mbo instanceof Location) {
                return (Location)mbo;
            }
            return null;
        }
        if (this.getRecordType() == 2) {
            mbo = this.dataBean.getMbo(0);
            if (mbo != null && mbo instanceof Location) {
                return (Location)mbo;
            }
            if (this.dataBean.getMboSet().getQbeWhere() != null && !this.dataBean.getMboSet().getQbeWhere().equals("")) {
                String oldQBEWhere = this.dataBean.getMboSet().getQbeWhere();
                this.dataBean.getMboSet().clear();
                this.dataBean.getMboSet().setWhere(oldQBEWhere);
                this.dataBean.reset();
                mbo = this.dataBean.getMboSet().getMbo(0);
                return (Location)mbo;
            }
            if (this.dataBean.getMboSet().getWhere() != null && !this.dataBean.getMboSet().getWhere().equals("") && this.dataBean.getMboSet().getRelationship() != null && !this.dataBean.getMboSet().getRelationship().equals("")) {
                String oldWhere = this.dataBean.getMboSet().getWhere();
                this.cleandDatabeanWhere(this.dataBean);
                this.dataBean.getMboSet().setWhere(oldWhere);
                this.dataBean.reset();
                mbo = this.dataBean.getMboSet().getMbo(0);
                return (Location)mbo;
            }
            return null;
        }
        return null;
    }

    private void cleandDatabeanWhere(DataBean dataBean) throws RemoteException, MXException {
        dataBean.getMboSet().setAppWhere("");
        dataBean.getMboSet().resetQbe();
        dataBean.getMboSet().setUserWhere("");
        dataBean.getMboSet().setWhere("");
        dataBean.getMboSet().setRelationship("");
    }

    protected MboSetRemote lookupModelFileForLocation(LocationRemote locMbo) {
        try {
            String siteId = locMbo.getString(FIELD_SITEID);
            String orgId = locMbo.getString(FIELD_ORGID);
            String systemId = locMbo.getString(FIELD_SYSTEMID);
            String location = locMbo.getString(FIELD_LOCATION);
            String viewerTypeList = this._modelSet.getVieweerTypeList(siteId, orgId);
            if (systemId == null || systemId.length() == 0) {
                SqlFormat sqlPrimarySystem = new SqlFormat((MboRemote)locMbo, "siteid=:1 AND PRIMARYSYSTEM=1");
                sqlPrimarySystem.setObject(1, TABLE_LOCSYSTEM, FIELD_SITEID, siteId);
                MboSetRemote primarySystemSet = locMbo.getMboSet("$getSystems", TABLE_LOCSYSTEM, sqlPrimarySystem.format());
                Object[] params = new String[]{location, siteId};
                if (primarySystemSet.isEmpty()) {
                    throw new MXApplicationException("bimimport", "no-primary-sys", params);
                }
                MboRemote ancestorMbo = primarySystemSet.getMbo(0);
                systemId = ancestorMbo.getString(FIELD_SYSTEMID);
            }
            StringBuffer query = new StringBuffer("( ");
            query.append(QUERY_MODEL_FILE);
            query.append(" )");
            query.append(" AND ");
            query.append(" ( ");
            query.append("VIEWERTYPE");
            query.append(" IN ( ");
            query.append(viewerTypeList);
            query.append(" )");
            if (this._activeViewer.equals("navisworks")) {
                query.append("OR (");
                query.append("VIEWERTYPE");
                query.append(" IS NULL");
                query.append(" )");
            }
            query.append(")");
            SqlFormat sqlf = new SqlFormat(query.toString());
            sqlf.setObject(1, TABLE_LOCATIONS, FIELD_LOCATION, location);
            sqlf.setObject(2, TABLE_LOCATIONS, FIELD_SITEID, siteId);
            sqlf.setObject(3, TABLE_LOCATIONS, FIELD_SYSTEMID, systemId);
            this._modelSet.setWhere(sqlf.format());
            this._modelSet.setOrderBy("PRIORITY DESC");
            this._modelSet.reset();
            return this._modelSet;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public LocationRemote lookupLocation(String location) throws RemoteException, MXException {
        this.dataBean.setCurrentRow(0);
        String siteId = this.dataBean.getString(FIELD_SITEID);
        return BIMViewer.lookupLocation(this.dataBean.getMbo(0), location, siteId);
    }

    public LocationRemote lookupLocationFromModelId(String modelId) throws RemoteException, MXException {
        String siteId = this.dataBean.getString(FIELD_SITEID);
        return this.lookupLocationFromModelId(this._modelLocation, modelId, siteId);
    }

    public LocationRemote lookupLocationFromModelId(String modelLocation, String modelId) throws RemoteException, MXException {
        String siteId = this.dataBean.getString(FIELD_SITEID);
        return this.lookupLocationFromModelId(modelLocation, modelId, siteId);
    }

    public LocationRemote lookupLocationFromModelId(String modelLocation, String modelId, String siteId) throws RemoteException, MXException {
        if (modelLocation == null) {
            return null;
        }
        String field = this._binding;
        if (this._recordType == 1) {
            field = this._modelId;
        }
        try {
            SqlFormat sqlf = new SqlFormat(this.dataBean.getMbo(0), field + QUERY_LOC_MODELID);
            sqlf.setObject(1, TABLE_LOCATIONS, this._modelId, modelId);
            sqlf.setObject(2, TABLE_LOCATIONS, FIELD_LOCATION, modelLocation);
            sqlf.setObject(3, TABLE_LOCATIONS, FIELD_SITEID, siteId);
            MboSetRemote locSet = this.dataBean.getMbo(0).getMboSet("$getLocations", TABLE_LOCATIONS, sqlf.format());
            if (locSet.isEmpty()) {
                return null;
            }
            if (locSet.count() > 1) {
                // empty if block
            }
            return (LocationRemote)locSet.getMbo(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String lookupLocationModelId(String location, String siteId) throws RemoteException, MXException {
        LocationRemote locMbo;
        if (this._binding.equalsIgnoreCase(FIELD_LOCATION)) {
            return location;
        }
        String field = this._binding;
        if (this._type == 1) {
            field = this._modelId;
        }
        if ((locMbo = BIMViewer.lookupLocation(this.dataBean.getMbo(0), location, siteId)) == null) {
            return null;
        }
        return locMbo.getString(field);
    }

    public String lookupLocationFromWO(String woKey, String siteId) {
        try {
            MboRemote mbo = this.dataBean.getMbo(0);
            SqlFormat sqlf = new SqlFormat(mbo, "WONUM=:1 and siteid=:2");
            sqlf.setObject(1, TABLE_WORKORDER, FIELD_WO_NUM, woKey);
            sqlf.setObject(2, TABLE_WORKORDER, FIELD_SITEID, siteId);
            MboSetRemote resultSet = mbo.getMboSet("$getWorkOrder", TABLE_WORKORDER, sqlf.format());
            if (resultSet.isEmpty()) {
                return null;
            }
            MboRemote resultMbo = resultSet.getMbo(0);
            String location = resultMbo.getString(FIELD_LOCATION);
            String field = this._binding;
            if (this._type == 1) {
                field = this._modelId;
            }
            if (field.equalsIgnoreCase(FIELD_LOCATION)) {
                return location;
            }
            resultMbo = BIMViewer.lookupLocation(mbo, location, siteId);
            return resultMbo.getString(field);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected MboSetRemote lookupModelsForLocation(String location) throws RemoteException, MXException {
        MboRemote mbo = this.dataBean.getMbo(0);
        String siteId = this.dataBean.getString(FIELD_SITEID);
        SqlFormat sqlf = new SqlFormat(mbo, "location=:1 and siteid=:2");
        sqlf.setObject(1, "BUILDINGMODEL", FIELD_LOCATION, location);
        sqlf.setObject(2, "BUILDINGMODEL", FIELD_SITEID, siteId);
        return mbo.getMboSet("$getBuildingModel", "BUILDINGMODEL", sqlf.format());
    }

    protected long lookupUid(String modelId) throws RemoteException, MXException {
        String mboName = null;
        UserInfo uInfo = null;
        if (this.dataBean != null && this.dataBean.getMboSet() != null) {
            mboName = this.dataBean.getMboSet().getName();
            uInfo = this.dataBean.getMboSet().getUserInfo();
        } else {
            AppInstance app = this.getWebClientSession().getCurrentApp();
            mboName = app.getDataBean().getMboSet().getName();
            uInfo = app.getDataBean().getMboSet().getUserInfo();
        }
        if (mboName != null && uInfo != null) {
            MboSetRemote lookupMboSet = MXServer.getMXServer().getMboSet(mboName, uInfo);
            String whereClause = this._modelId + " = '" + modelId + "'";
            if (lookupMboSet.getMboSetInfo().getSiteOrgType() != 0) {
                whereClause = whereClause + "and orgid = '" + lookupMboSet.getProfile().getDefaultOrg() + "'";
            }
            lookupMboSet.setWhere(whereClause);
            lookupMboSet.reset();
            MboRemote lookupMbo = lookupMboSet.getMbo(0);
            if (lookupMbo != null) {
                return lookupMbo.getUniqueIDValue();
            }
        }
        return -1L;
    }

    private boolean compareModelLists(Vector<BIMModelSpec> list1, Vector<BIMModelSpec> list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static BaseInstance findByRenderId(BaseInstance root, String renderId) {
        String altRenderId = "NO MATCH";
        int idx = renderId.indexOf(95);
        if (idx > 0) {
            altRenderId = renderId.replaceFirst("_", "-");
        }
        if (root == null) {
            return root;
        }
        if (root.getRenderId().equals(renderId) || root.getRenderId().equals(altRenderId)) {
            return root;
        }
        List l = root instanceof ControlInstance ? ((ControlInstance)root).getComponents() : root.getChildren();
        for (Object o : l) {
            if (!(o instanceof BaseInstance)) continue;
            BaseInstance bi = (BaseInstance)o;
            if (bi.getRenderId().equals(renderId) || bi.getRenderId().equals(altRenderId)) {
                return bi;
            }
            if ((bi = BIMViewer.findByRenderId(bi, renderId)) == null) continue;
            return bi;
        }
        return null;
    }

    public static LocationSetRemote lookupLocations(MboRemote mbo, String location, String siteId) throws RemoteException, MXException {
        if (mbo == null) {
            return null;
        }
        SqlFormat sqlf = new SqlFormat(mbo, "LOCATION=:1 and siteid=:2");
        sqlf.setObject(1, TABLE_LOCATIONS, FIELD_LOCATION, location);
        sqlf.setObject(2, TABLE_LOCATIONS, FIELD_SITEID, siteId);
        return (LocationSetRemote)mbo.getMboSet("$getLocations", TABLE_LOCATIONS, sqlf.format());
    }

    public static LocationRemote lookupLocation(MboRemote mbo, String location, String siteId) throws RemoteException, MXException {
        LocationSetRemote locationSet = BIMViewer.lookupLocations(mbo, location, siteId);
        if (locationSet == null || locationSet.isEmpty()) {
            return null;
        }
        return (LocationRemote)locationSet.getMbo(0);
    }

    public static MboSetRemote lookupAssetsAtLocation(MboRemote locationMbo) {
        if (locationMbo == null) {
            return null;
        }
        try {
            String location = locationMbo.getString(FIELD_LOCATION);
            String siteId = locationMbo.getString(FIELD_SITEID);
            SqlFormat sqlf = new SqlFormat(locationMbo, "LOCATION=:1 and siteid=:2");
            sqlf.setObject(1, TABLE_ASSET, FIELD_LOCATION, location);
            sqlf.setObject(2, TABLE_ASSET, FIELD_SITEID, siteId);
            MboSetRemote assetSet = locationMbo.getMboSet("$getAssetSet", TABLE_ASSET, sqlf.format());
            return assetSet;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void changeBeanRecordSet(DataBean bean, long uid) throws RemoteException, MXException {
        bean.getMboSet().resetQbe();
        bean.getMboSet().clear();
        bean.getMboSet().setWhere(bean.getUniqueIdName() + " = " + uid);
        bean.getMboSet().reset();
    }
}

