/*
 * Decompiled with CFR 0.152.
 */
package psdi.webclient.beans.bim.viewer.lmv;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.servlet.http.HttpServletRequest;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.MXObjectNotFoundException;
import psdi.util.MXSystemException;
import psdi.webclient.system.beans.DataBean;
import psdi.webclient.system.controller.ControlInstance;
import psdi.webclient.system.controller.MPFormData;
import psdi.webclient.system.controller.UploadFile;
import psdi.webclient.system.controller.WebClientEvent;

public class ModelUploadSelectBean
extends DataBean {
    private MPFormData _mpData = null;
    private String _rootDir = "";

    public int loadModelFile() throws MXException, RemoteException {
        HttpServletRequest request = this.clientSession.getRequest();
        try {
            this._rootDir = MXServer.getMXServer().getProperty("bim.model.dir");
            File file = new File(this._rootDir);
            boolean exists = file.exists();
            if (!exists) {
                throw new MXObjectNotFoundException("bimviewer", "model-dir-missing");
            }
        }
        catch (Exception e) {
            throw new MXObjectNotFoundException("system", "objectnotfound", (Throwable)e);
        }
        WebClientEvent wce = this.clientSession.getCurrentEvent();
        ControlInstance uploadfileControl = wce.getSourceControlInstance();
        MXServer server = MXServer.getMXServer();
        String maxfilesize = server.getProperty("bim.viewer.LMV.model.maxuploadsize");
        if (maxfilesize != null && maxfilesize.length() > 0) {
            uploadfileControl.setProperty("maxfilesize", maxfilesize);
        }
        maxfilesize = uploadfileControl.getProperty("maxfilesize");
        try {
            this._mpData = new MPFormData(request, Integer.parseInt(maxfilesize));
            UploadFile uf = new UploadFile(this._mpData.getFileName(), this._mpData.getFullFileName(), this._mpData.getFileContentType(), this._mpData.getFileOutputStream());
            uf.setDirectoryName(this._rootDir);
            uf.writeToDisk();
            String srcFileName = this._mpData.getFullFileName();
            String uploadFileName = uf.getFileName();
            String fileName = this._rootDir + File.separatorChar + uploadFileName;
            this.setValue("FILENAME", fileName);
            this.setValue("OBJECTKEY", srcFileName);
            if (MPFormData.isRequestMultipart((HttpServletRequest)request)) {
                DataBean bean = this.app.getDataBean("LMV_MODEL_UPLOAD");
                if (bean == null) {
                    bean = this.getParent();
                }
                if (bean != null) {
                    bean.setValue("OBJECTKEY", srcFileName);
                    bean.setValue("FILENAME", fileName);
                    this.app.getAppBean().fireDataChangedEvent();
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new MXApplicationException("bimimport", "bim-file-missing");
        }
        catch (IOException e) {
            throw new MXSystemException("system", "major", (Throwable)e);
        }
        return 1;
    }
}

