/*
 * Decompiled with CFR 0.152.
 */
package psdi.webclient.beans.bim.viewer.lmv;

import java.rmi.RemoteException;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.util.MXException;
import psdi.webclient.beans.bim.viewer.lmv.BaseManageBean;
import psdi.webclient.system.beans.DataBean;
import psdi.webclient.system.controller.ControlInstance;
import psdi.webclient.system.controller.WebClientEvent;

public class BaseDlgBean
extends DataBean {
    private boolean _initialized = false;
    private int _row = -1;
    private ControlInstance _ctrl;

    public void initialize() throws MXException, RemoteException {
        super.initialize();
        if (this._initialized) {
            this.moveTo(this._row);
            this.select(this._row);
            return;
        }
        WebClientEvent event = this.clientSession.getCurrentEvent();
        this._row = this.getRowIndexFromEvent(event);
        this._ctrl = event.getSourceControlInstance();
        this.moveTo(this._row);
        this.select(this._row);
        MboRemote mbo = this.getMbo();
        mbo.getThisMboSet().setLogLargFetchResultDisabled(true);
        try {
            String siteId = this.app.getDataBean().getString("SITEID");
            if (siteId.length() > 0) {
                mbo.setValue("SITEID", siteId, 2L);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._initialized = true;
    }

    protected ControlInstance getControl() {
        return this._ctrl;
    }

    protected void refresh() throws RemoteException, MXException {
        DataBean db;
        this.reset();
        if (this._ctrl != null && (db = this._ctrl.getDataBean()) != null) {
            MboSetRemote mboSet = db.getMboSet();
            mboSet.reset();
            db.refreshTable();
        }
    }

    public int cancelDialog() throws MXException, RemoteException {
        DataBean db = this._ctrl.getDataBean();
        if (db instanceof BaseManageBean) {
            BaseManageBean baseBean = (BaseManageBean)db;
            return baseBean.dialogCanceled();
        }
        return super.cancelDialog();
    }

    public synchronized int execute() throws MXException, RemoteException {
        DataBean db = this._ctrl.getDataBean();
        db.refreshTable();
        return super.execute();
    }

    protected MboSetRemote getMboSetRemote() throws MXException, RemoteException {
        if (this._ctrl == null) {
            WebClientEvent event = this.clientSession.getCurrentEvent();
            this._ctrl = event.getSourceControlInstance();
        }
        if (this._ctrl == null) {
            return null;
        }
        DataBean bean = this._ctrl.getDataBean();
        MboSetRemote mboSet = bean.getMboSet();
        return mboSet;
    }
}

