/*
 * Decompiled with CFR 0.152.
 */
package psdi.webclient.beans.bim.viewer;

import java.rmi.RemoteException;
import java.util.Hashtable;
import psdi.app.bim.viewer.virtual.BIMWorkOrderTreeRemote;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.util.MXException;
import psdi.webclient.beans.bim.viewer.WOTreeBaseBean;
import psdi.webclient.beans.common.AssetLocDrilldownBean;
import psdi.webclient.components.BIMViewer;
import psdi.webclient.system.beans.DataBean;
import psdi.webclient.system.beans.DataBeanListener;
import psdi.webclient.system.controller.ComponentInstance;
import psdi.webclient.system.controller.ControlInstance;
import psdi.webclient.system.session.WebClientSession;

public class WOTreeBean
extends WOTreeBaseBean {
    private BIMViewer _model = null;
    private String _assetnum = "";
    private String _location = "";
    private String _siteId = "";
    DataBean _locationBean;
    DataBean _assetBean;

    protected void initialize() throws MXException, RemoteException {
        MboSetRemote locMboSet;
        MboRemote locMbo;
        ComponentInstance ci;
        ComponentInstance horiz;
        ComponentInstance vert;
        ControlInstance bvCtrl;
        super.initialize();
        if (this._viewModelLocBean != null) {
            this._viewModelLocBean.setCurrentRecordToAppLocation();
            WebClientSession wcs = this.app.getWebClientSession();
            ControlInstance ctrl = wcs.findControl("view_tree_loc");
            if (ctrl != null) {
                DataBean db = ctrl.getDataBean();
                db.getMboForUniqueId(this._viewModelLocBean.getUniqueIdValue());
            }
        }
        if ((bvCtrl = this.clientSession.getControlInstance("model_location_view")) != null && (vert = (ComponentInstance)bvCtrl.getComponents().get(0)) != null && (horiz = (ComponentInstance)vert.getChildren().get(0)) != null && (ci = (ComponentInstance)horiz.getChildren().get(0)) != null && ci instanceof BIMViewer) {
            this._model = (BIMViewer)ci;
            this._model.forceUpdate();
        }
        DataBean appBean = this.app.getDataBean();
        MboRemote woNewMbo = appBean.getMbo();
        boolean newVO = false;
        if (woNewMbo != this._woMbo) {
            this._woMbo = woNewMbo;
            newVO = true;
        }
        this._viewModelLocBean.addListener((DataBeanListener)this);
        this._viewModelLocBean.setMainTree(this);
        this._viewTreeLocBean.addListener((DataBeanListener)this);
        appBean.addListener((DataBeanListener)this);
        WebClientSession wcs = this.app.getWebClientSession();
        ControlInstance ctrl = wcs.findControl("main_grid3_4");
        if (ctrl != null) {
            this._locationBean = ctrl.getDataBean();
            this._locationBean.addListener((DataBeanListener)this);
        }
        if ((ctrl = wcs.findControl("main_grid3_10")) != null) {
            this._assetBean = ctrl.getDataBean();
            this._assetBean.addListener((DataBeanListener)this);
        }
        if (newVO && (locMbo = (locMboSet = this._woMbo.getMboSet("LOCATION")).getMbo(0)) != null) {
            this._viewTreeLocBean.getMboForUniqueId(locMbo.getUniqueIDValue());
        }
        this.update();
    }

    private void update() throws RemoteException, MXException {
        boolean changed = false;
        DataBean appBean = this.app.getAppBean();
        String assetnum = appBean.getString("ASSETNUM");
        String location = appBean.getString("LOCATION");
        String siteId = appBean.getString("SITEID");
        if (!this._assetnum.equals(assetnum)) {
            changed = true;
            this._assetnum = assetnum;
        }
        if (!this._location.equals(location)) {
            changed = true;
            this._location = location;
        }
        if (!this._siteId.equals(siteId)) {
            changed = true;
            this._siteId = siteId;
        }
        if (changed) {
            this.populateTree();
            this.processLocationChange();
            WOTreeBaseBean.CacheEntry node = this.lookupAsset(this._siteId, this._assetnum);
            if (node == null) {
                node = this.lookupLocation(this._siteId, this._location);
            }
            if (node != null && node._mbo != null) {
                this.setuniqueidname(node._mbo.getUniqueIDName());
            }
        }
    }

    protected void selectItemInModel(long num) throws RemoteException, MXException {
        super.selectItemInModel(num);
        if (this._viewModelLocBean != null && this._viewModelLocBean.getMultiTree() != null) {
            this._viewModelLocBean.getMultiTree().processLocationChange();
        }
    }

    public void dataChangedEvent(DataBean speaker) {
        if (speaker instanceof AssetLocDrilldownBean) {
            return;
        }
        if (speaker == this.app.getDataBean() || speaker == this._locationBean || speaker == this._assetBean) {
            try {
                this.update();
                this.fireStructureChangedEvent();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        if (speaker == this._viewModelLocBean) {
            this.processLocationChange();
            return;
        }
        super.dataChangedEvent(speaker);
    }

    private void populateTree() throws RemoteException, MXException {
        WOTreeBaseBean.CacheEntry node;
        MboSetRemote treeSet = this.getMboSetRemote();
        treeSet.clear();
        this.getBoundTree().setChangedFlag(true);
        Hashtable mboCache = new Hashtable();
        if (this._assetnum != null && this._assetnum.length() > 0) {
            node = this.lookupAsset(this._siteId, this._assetnum);
            if (node == null) {
                return;
            }
        } else if (this._location != null && this._location.length() > 0) {
            node = this.lookupLocation(this._siteId, this._location);
            if (node == null) {
                return;
            }
        } else {
            return;
        }
        BIMWorkOrderTreeRemote treeMbo = (BIMWorkOrderTreeRemote)treeSet.add();
        this.populateTreeNode((MboRemote)treeMbo, node);
        this.populatePathToTop(treeSet, treeMbo, mboCache, node);
    }
}

