/*
 * Decompiled with CFR 0.152.
 */
package psdi.webclient.beans.bim.viewer;

import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.webclient.beans.bim.viewer.AssetLookupBase;
import psdi.webclient.beans.bim.viewer.WOTreeBaseBean;
import psdi.webclient.system.beans.DataBean;

public class WOModelLocBean
extends AssetLookupBase {
    private WOTreeBaseBean _mainTree = null;
    private WOTreeBaseBean _multiTree = null;

    @Override
    protected void initialize() throws MXException, RemoteException {
        super.initialize();
    }

    public void eventAddSelection() throws RemoteException, MXException {
        DataBean appBean = this.app.getDataBean();
        MboRemote appMbo = appBean.getMbo();
        String siteId = this.getString("SITEID");
        DataBean multiLocDataBean = this.getMultiLocCITable(appMbo);
        HashSet<String> selectedAssets = new HashSet<String>();
        HashSet<String> selectedLocations = new HashSet<String>();
        if (!this.lookupSelectedAssetsAndLocations(siteId, selectedAssets, selectedLocations)) {
            return;
        }
        this.filterAndUndelete(multiLocDataBean, siteId, selectedAssets, selectedLocations);
        this.insertAssets(appMbo, selectedAssets, siteId);
        this.insertLocations(appMbo, selectedLocations, siteId);
        if (multiLocDataBean != null) {
            multiLocDataBean.fireStructureChangedEvent();
            multiLocDataBean.refreshTable();
        }
    }

    public void eventRemoveSelection() throws RemoteException, MXException {
        DataBean appBean = this.app.getDataBean();
        MboRemote appMbo = appBean.getMbo();
        String siteId = this.getString("SITEID");
        DataBean multiLocDataBean = this.getMultiLocCITable(appMbo);
        HashSet<String> selectedAssets = new HashSet<String>();
        HashSet<String> selectedLocations = new HashSet<String>();
        if (!this.lookupSelectedAssetsAndLocations(siteId, selectedAssets, selectedLocations)) {
            return;
        }
        int i = 0;
        while (i < multiLocDataBean.count()) {
            String itemSiteId;
            MboRemote multiLocMbo = multiLocDataBean.getMbo(i);
            if (!multiLocMbo.toBeDeleted() && (itemSiteId = multiLocMbo.getString("SITEID")) != null && itemSiteId.length() != 0 && siteId.equals(itemSiteId)) {
                String assetnum = multiLocMbo.getString("ASSETNUM");
                if (assetnum != null && assetnum.length() > 0) {
                    if (selectedAssets.contains(assetnum)) {
                        multiLocDataBean.delete(i);
                    }
                } else {
                    String location = multiLocMbo.getString("LOCATION");
                    if (location != null && location.length() > 0 && selectedLocations.contains(location)) {
                        multiLocDataBean.delete(i);
                    }
                }
            }
            ++i;
        }
    }

    boolean lookupSelectedAssetsAndLocations(String siteId, Set<String> selectedAssets, Set<String> selectedLocatios) throws RemoteException, MXException {
        String location;
        MboRemote locMbo;
        selectedAssets.clear();
        selectedLocatios.clear();
        Set<String> values = this.getValueList();
        MboSetRemote mboSet = this.lookupLocationListFromModelId(values, siteId);
        if (mboSet.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < mboSet.count()) {
            locMbo = mboSet.getMbo(i);
            location = locMbo.getString("LOCATION");
            selectedLocatios.add(location);
            ++i;
        }
        mboSet.cleanup();
        mboSet = this.lookupAssetsAtLocations(selectedLocatios, siteId);
        i = 0;
        while (i < mboSet.count()) {
            locMbo = mboSet.getMbo(i);
            location = locMbo.getString("LOCATION");
            selectedLocatios.remove(location);
            String assetnum = locMbo.getString("ASSETNUM");
            selectedAssets.add(assetnum);
            ++i;
        }
        return true;
    }

    MboSetRemote lookupLocationListFromModelId(Set<String> values, String siteId) throws RemoteException, MXException {
        StringBuffer query = new StringBuffer();
        String inClause = this.formatInClause(values.iterator());
        if (inClause == null || inClause.length() == 0) {
            return null;
        }
        query.append("SITEID");
        query.append(" = '");
        query.append(siteId);
        query.append("' AND ");
        query.append(this.getBinding());
        query.append(inClause);
        MXServer server = MXServer.getMXServer();
        MboSetRemote locationSet = server.getMboSet("LOCATIONS", this.getMbo(0).getUserInfo());
        if (locationSet == null) {
            throw new MXApplicationException("bimviewer", "Internal-error");
        }
        locationSet.setWhere(query.toString());
        locationSet.reset();
        return locationSet;
    }

    MboSetRemote lookupAssetsAtLocations(Set<String> values, String siteId) throws RemoteException, MXException {
        StringBuffer query = new StringBuffer();
        String inClause = this.formatInClause(values.iterator());
        if (inClause == null || inClause.length() == 0) {
            return null;
        }
        query.append("SITEID");
        query.append(" = '");
        query.append(siteId);
        query.append("' AND ");
        query.append("LOCATION");
        query.append(inClause);
        MXServer server = MXServer.getMXServer();
        MboSetRemote locationSet = server.getMboSet("ASSET", this.getMbo(0).getUserInfo());
        if (locationSet == null) {
            throw new MXApplicationException("bimviewer", "Internal-error");
        }
        locationSet.setWhere(query.toString());
        locationSet.reset();
        return locationSet;
    }

    void filterItems(String siteId, Set<String> existing, Set<String> selected) {
        Iterator<String> itr = selected.iterator();
        while (itr.hasNext()) {
            String item = itr.next();
            if (!existing.contains(String.valueOf(item) + siteId)) continue;
            itr.remove();
        }
    }

    public WOTreeBaseBean getMainTree() {
        return this._mainTree;
    }

    public void setMainTree(WOTreeBaseBean mainTree) {
        this._mainTree = mainTree;
    }

    public WOTreeBaseBean getMultiTree() {
        return this._multiTree;
    }

    public void setMultiTree(WOTreeBaseBean multiTree) {
        this._multiTree = multiTree;
    }
}

