/*
 * Decompiled with CFR 0.152.
 */
package psdi.webclient.beans.bim.viewer;

import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import psdi.app.asset.AssetSetRemote;
import psdi.app.ticket.TicketRemote;
import psdi.app.workorder.WORemote;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.webclient.components.BIMViewer;
import psdi.webclient.system.beans.DataBean;
import psdi.webclient.system.controller.ComponentInstance;
import psdi.webclient.system.controller.WebClientEvent;

public class AssetLookupBaseToo
extends DataBean {
    private HashSet<String> _values = null;
    private String _binding = "modelid";
    private BIMViewer _model = null;

    protected void initialize() throws MXException, RemoteException {
        super.initialize();
        MboRemote appMbo = this.app.getDataBean().getMbo();
        if (appMbo != null && !appMbo.isNull("location") && !appMbo.getString("location").equals("")) {
            this.setCurrentBeanRecord(appMbo.getString("location"));
        }
    }

    public int bimviewer() {
        WebClientEvent event = this.clientSession.getCurrentEvent();
        ComponentInstance ci = event.getSourceComponentInstance();
        if (ci != null && ci instanceof BIMViewer) {
            this._model = (BIMViewer)ci;
            this._binding = this._model.getBinding();
        }
        return 1;
    }

    public int bimModelListChanged() throws RemoteException, MXException {
        WebClientEvent event = this.clientSession.getCurrentEvent();
        Object o = event.getValue();
        if (o == null || !(o instanceof String)) {
            throw new MXApplicationException("bimviewer", "Internal-error");
        }
        String modelLocation = (String)o;
        if (modelLocation.length() == 0) {
            return 1;
        }
        this.setCurrentBeanRecord(modelLocation);
        return 1;
    }

    public void setCurrentBeanRecord(String modelLocation) throws RemoteException, MXException {
        MboRemote mbo = this.getMbo();
        String siteId = this.getString("SITEID");
        SqlFormat sqlf = new SqlFormat(mbo, "LOCATION=:1 and siteid=:2");
        sqlf.setObject(1, "LOCATIONS", "LOCATION", modelLocation);
        sqlf.setObject(2, "LOCATIONS", "SITEID", siteId);
        MXServer server = MXServer.getMXServer();
        MboSetRemote locationSet = server.getMboSet("LOCATIONS", this.getMboSet().getUserInfo());
        locationSet.setWhere(sqlf.format());
        locationSet.reset();
        mbo = locationSet.getMbo(0);
        if (mbo != null) {
            long uid = mbo.getUniqueIDValue();
            this.getMboSet().setWhere("");
            this.getMboSet().setRelationship("");
            this.getMboSet().getMboForUniqueId(uid);
        }
    }

    public void setCurrentBeanRecordByLocId(long locationId) throws RemoteException, MXException {
        this.getMboSet().getMboForUniqueId(locationId);
    }

    protected void setLocToModelLoc(WebClientEvent event) throws RemoteException, MXException {
    }

    public int eventMultiSelect() {
        this._values = new HashSet();
        WebClientEvent event = this.clientSession.getCurrentEvent();
        ComponentInstance ci = event.getSourceComponentInstance();
        if (ci != null && ci instanceof BIMViewer) {
            this._model = (BIMViewer)ci;
            this._binding = this._model.getBinding();
        }
        return this.appendSelection();
    }

    public int appendSelection() {
        WebClientEvent event = this.clientSession.getCurrentEvent();
        Object o = event.getValue();
        if (o == null || !(o instanceof String)) {
            return 1;
        }
        String[] result = ((String)o).split(";");
        int i = 0;
        while (i < result.length) {
            this._values.add(result[i]);
            ++i;
        }
        return 1;
    }

    public String getBinding() {
        return this._binding;
    }

    public BIMViewer getModel() throws MXApplicationException {
        if (this._model == null) {
            throw new MXApplicationException("bimviewer", "Internal-error");
        }
        return this._model;
    }

    DataBean getMultiLocCITable(MboRemote appMbo) throws RemoteException, MXApplicationException {
        if (appMbo.isBasedOn("WORKORDER")) {
            return this.app.getDataBean("work_multiassetlocci_table");
        }
        if (appMbo.isBasedOn("TICKET")) {
            return this.app.getDataBean("main_multiassetlocci_table");
        }
        throw new MXApplicationException("bimviewer", "unsupported-app");
    }

    public Set<String> getValueList() throws MXApplicationException {
        BIMViewer model = this.getModel();
        Set<String> sel = model.getCurrentSelection();
        if (sel == null || sel.size() == 0) {
            throw new MXApplicationException("bimviewer", "no-item-selected");
        }
        return sel;
    }

    public synchronized int returnLookupValue(MboRemote lookupMbo) throws MXException {
        if (this.mboSetRemote == null || lookupMbo == null) {
            return 1;
        }
        try {
            if (lookupMbo.isBasedOn("LOCATIONS")) {
                long uid = lookupMbo.getUniqueIDValue();
                this.getMboForUniqueId(uid);
            } else if (lookupMbo.isBasedOn("SITE")) {
                String siteId = lookupMbo.getString("SITEID");
                this.resetQbe();
                this.setQbe("SITEID", siteId);
                this.moveTo(0);
                this.fireStructureChangedEvent();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return 1;
    }

    protected void testResultsForDuplicates(Set<String> assetnumSet, MboSetRemote resultSet, Set<String> existingAssets) throws RemoteException, MXException {
        int i = 0;
        while (i < resultSet.count()) {
            String siteId;
            MboRemote assetMbo = resultSet.getMbo(i);
            String assetnum = assetMbo.getString("ASSETNUM");
            if (assetnum != null && assetnum.length() != 0 && (siteId = assetMbo.getString("SITEID")) != null && siteId.length() != 0 && !existingAssets.contains(String.valueOf(assetnum) + siteId)) {
                assetnumSet.add(assetnum);
            }
            ++i;
        }
    }

    public void insertAssets(MboRemote appMbo, Set<String> newAssets, String siteid) throws RemoteException, MXException {
        StringBuffer query = new StringBuffer();
        String inClause = this.formatInClause(newAssets.iterator());
        if (inClause == null || inClause.length() == 0) {
            return;
        }
        query.append("SITEID");
        query.append(" = '");
        query.append(siteid);
        query.append("' AND ");
        query.append("ASSETNUM");
        query.append(inClause);
        MXServer server = MXServer.getMXServer();
        MboSetRemote assetSet = server.getMboSet("ASSET", appMbo.getUserInfo());
        if (assetSet == null) {
            throw new MXApplicationException("bimviewer", "Internal-error");
        }
        assetSet.setWhere(query.toString());
        assetSet.reset();
        int i = 0;
        while (i < assetSet.count()) {
            assetSet.select(i);
            ++i;
        }
        if (appMbo.isBasedOn("WORKORDER")) {
            WORemote workorder = (WORemote)appMbo;
            workorder.copyAssetsToMultiAsset((AssetSetRemote)assetSet);
        } else if (appMbo.isBasedOn("TICKET")) {
            TicketRemote ticket = (TicketRemote)appMbo;
            ticket.copyAssetsToMultiAsset((AssetSetRemote)assetSet);
        }
        assetSet.cleanup();
    }

    public void insertLocations(MboRemote appMbo, Set<String> newLocations, String siteid) throws RemoteException, MXException {
        StringBuffer query = new StringBuffer();
        String inClause = this.formatInClause(newLocations.iterator());
        if (inClause == null || inClause.length() == 0) {
            return;
        }
        query.append("SITEID");
        query.append(" = '");
        query.append(siteid);
        query.append("' AND ");
        query.append("LOCATION");
        query.append(inClause);
        MXServer server = MXServer.getMXServer();
        MboSetRemote locationSet = server.getMboSet("LOCATIONS", appMbo.getUserInfo());
        if (locationSet == null) {
            throw new MXApplicationException("bimviewer", "Internal-error");
        }
        locationSet.setWhere(query.toString());
        locationSet.reset();
        int i = 0;
        while (i < locationSet.count()) {
            locationSet.select(i);
            ++i;
        }
        if (appMbo.isBasedOn("WORKORDER")) {
            WORemote workorder = (WORemote)appMbo;
            workorder.copyLocationsToMultiAsset(locationSet);
        } else if (appMbo.isBasedOn("TICKET")) {
            TicketRemote ticket = (TicketRemote)appMbo;
            ticket.copyLocationsToMultiAsset(locationSet);
        }
        locationSet.cleanup();
    }

    protected void filterAndUndelete(DataBean multiLocDataBean, String modelSiteId, Set<String> selectedAssets, Set<String> selectedLocations) throws RemoteException, MXException {
        if (selectedAssets == null) {
            selectedAssets = new HashSet<String>();
        }
        if (selectedLocations == null) {
            selectedLocations = new HashSet<String>();
        }
        if (multiLocDataBean == null) {
            return;
        }
        int i = 0;
        while (i < multiLocDataBean.count()) {
            MboRemote multiLocMbo = multiLocDataBean.getMbo(i);
            String siteId = multiLocMbo.getString("SITEID");
            if (siteId != null && siteId.length() != 0 && siteId.equals(modelSiteId)) {
                String assetnum = multiLocMbo.getString("ASSETNUM");
                if (assetnum != null && assetnum.length() > 0) {
                    if (selectedAssets.contains(assetnum)) {
                        selectedAssets.remove(assetnum);
                        if (multiLocMbo.toBeDeleted()) {
                            multiLocMbo.undelete();
                        }
                    }
                } else {
                    String location = multiLocMbo.getString("LOCATION");
                    if (location != null && location.length() > 0 && selectedLocations.contains(location)) {
                        selectedLocations.remove(location);
                        if (multiLocMbo.toBeDeleted()) {
                            multiLocMbo.undelete();
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected String formatInClause(Iterator<String> itr) {
        StringBuffer inCluase = new StringBuffer();
        inCluase.append(" IN ( ");
        boolean first = true;
        while (itr.hasNext()) {
            if (!first) {
                inCluase.append(", ");
            }
            inCluase.append("'");
            inCluase.append(itr.next());
            inCluase.append("'");
            first = false;
        }
        if (first) {
            return "";
        }
        inCluase.append(")");
        return inCluase.toString();
    }
}

